 ; Ŀ
 ;   Gc - install a ground conductor line, and Ga, install an arc.         
 ;   Copyright 2005, 2010 by Rocket Software Ltd.                          
 ;   Can serrated knives be considered digital?                            
 ; 
 (DEFUN C:GC (/ *error* osmo clay pa pb enam dscal)
  (setvar "cmdecho" 0)
  (command "undo" "be")
  (setq osmo (getvar "osmode"))
  (setq clay (getvar "clayer"))
  (defun *error* (shk)
   (setvar "osmode" osmo)
   (setvar "clayer" clay)
   (command "undo" "end")
  (princ))
 ; Ŀ
 ;   Load Misps.lsp, which contains the ps/ms scaling subroutines.         
 ; 
  (if (or (null wasp) (null misps))
      (if (null (load "misps" ()))
          (prompt "\n** The File Misps.lsp Is Not Available. **\n")))
  (setq dscal (misps))
  (setvar "osmode" 512)           ; nearest
  (if c:malaya (malaya "ground"))
  (setq pa (getpoint "Ground Line:"))
  (if (setq enam (car (nentselp pa)))
      (command ".change" enam "" "p" "la" "ground" ""))
  (setvar "osmode" 128)           ; perpendicular
  (setq pb (getpoint pa "\nDevice to ground:"))
  (setvar "osmode" 0)
  (command ".line" pa pb "")
  (command ".insert" "groundtap" pa dscal "" 0)
  (command ".insert" "groundcon" pb dscal "" 0)
  (*error*)
 (princ))

 ; Ŀ
 ;   Ga - install a ground conductor arc.                                  
 ; 
 (DEFUN C:GA (/ *error* osmo clay pa pb enam dscal)
  (setvar "cmdecho" 0)
  (command "undo" "be")
  (setq osmo (getvar "osmode"))
  (setq clay (getvar "clayer"))
  (defun *error* (shk)
   (setvar "osmode" osmo)
   (setvar "clayer" clay)
   (command "undo" "end")
  (princ))
 ; Ŀ
 ;   Load Misps.lsp, which contains the ps/ms scaling subroutines.         
 ; 
  (if (or (null wasp) (null misps))
      (if (null (load "misps" ()))
          (prompt "\n** The File Misps.lsp Is Not Available. **\n")))
  (setq dscal (misps))
  (setvar "osmode" 512)           ; nearest
  (if c:malaya (malaya "ground"))
  (setq pa (getpoint "Ground Line:"))
  (if (setq enam (car (nentselp pa)))
      (command ".change" enam "" "p" "la" "ground" ""))
  (setvar "osmode" 545)           ; 1 = end, 32 = int, 512 = nearest
  (setq pb (getpoint pa "\nDevice to ground:"))
  (setvar "osmode" 0)
  (command ".arc" pa "e" pb "d" (+ (* (/ 180 pi) (angle pa pb)) 30))
  (command ".insert" "groundtap" pa dscal "" 0)
  (command ".insert" "groundcon" pb dscal "" 0)
  (*error*)
 (princ))

(princ)
